/******************************************************************************
 * (C) Copyright 2000 by Agilent Technologies GmbH. All rights reserved.      *
 ******************************************************************************/


/* ---------------------------------------------------------------
 * File: xtdecdef.h 
 *       Type definitions for decoder functions
 * -----------------------------------------------------------------*/

#ifndef XTDECDEFS_H_INCLUDED                               
#define XTDECDEFS_H_INCLUDED

#ifndef CLI
#define CLI
#endif

/********************************************************************
  Decoders **********************************************************
 *******************************************************************/

#define BX_DECODER_SIZE 9

CLI typedef enum {
  BX_DEC_BAR0=0,   /* @bar0 */
  BX_DEC_BAR1=1,   /* @bar1 */
  BX_DEC_BAR2=2,   /* @bar2 */
  BX_DEC_BAR3=3,   /* @bar3 */
  BX_DEC_BAR4=4,   /* @bar4 */
  BX_DEC_BAR5=5,   /* @bar5 */
  BX_DEC_EXPROM=6, /* @exprom */
  BX_DEC_RT=7,     /* @rtdec */
  BX_DEC_CONFIG=8, /* @config */
  BX_DEC_NODECODER /* $enumsize @nodecoder */
} bx_dectype;

/********************************************************************
  Decoder properties ************************************************
 *******************************************************************/

#define BX_DECPROP_SIZE  9

CLI typedef enum {
  BX_DECP_SIZE,         /* @size     */    /* stored in DB config space */
  BX_DECP_PREFETCH,     /* @prefetch */    /* stored in DB config space */
  BX_DECP_LOCATION,     /* @location */    /* stored in DB config space */
  BX_DECP_BASEADDR,     /* @baseaddr */    /* stored in DB config space */
  BX_DECP_BASEADDR_HI,  /* @baseaddrhi */  /* stored in DB config space */
  BX_DECP_RESOURCE,     /* @resource */       
  BX_DECP_RESBASE,      /* @resbase  */       
  BX_DECP_RESSIZE,      /* @ressize  */
  BX_DECP_COMPARE       /* @compare  */ 
} bx_decproptype;

CLI  /* DEF_START ~G_BX_DECP_LOCATION */
#define BX_DECP_LOCATION_OFF   0xFFFFFFFFUL    /* @locationoff */
#define BX_DECP_LOCATION_MEM   0x0UL /* @locationmem */
#define BX_DECP_LOCATION_IO    0x1UL /* @locationio */
CLI  /* DEF_END */

CLI  /* DEF_START ~G_BX_DECP_RESOURCE */
#define BX_DECP_RESOURCE_MEM    0UL /* @resourcemem   */
#define BX_DECP_RESOURCE_GEN    1UL /* @resourcegen   */
#define BX_DECP_RESOURCE_FLASH  2UL /* @resourceflash */
#define BX_DECP_RESOURCE_CFG    3UL /* @resourcecfg   */
CLI  /* DEF_END */

#endif
